# Blesser UI Component Documentation

This document provides examples and usage guidelines for the UI components available in the Blesser library.

## Form Components

### Input

The `input` component is used for creating various types of text-based input fields.

```html
{{-- Basic usage --}}
<x-blesser.ui.form.input name="username" label="شماره موبایل یا ایمیل" />

{{-- With a specific type and initial value --}}
<x-blesser.ui.form.input name="email" type="email" label="Email Address" value="test@example.com" />

{{-- Required field --}}
<x-blesser.ui.form.input name="password" type="password" label="Password" required />

{{-- With a placeholder --}}
<x-blesser.ui.form.input name="search" label="Search" placeholder="Enter search term..." />

{{-- Disabled field --}}
<x-blesser.ui.form.input name="disabled_field" label="Disabled Field" value="Cannot change" disabled />

{{-- Readonly field --}}
<x-blesser.ui.form.input name="readonly_field" label="Readonly Field" value="Readonly value" readonly />

{{-- Adding extra classes for styling --}}
<x-blesser.ui.form.input name="custom_field" label="Custom Field" class="mt-4 border-blue-500" />

{{-- Input with help text --}}
<x-blesser.ui.form.input name="phone" label="Phone Number" help="Please enter your primary phone number." />
```



### textarea

```html
You can use this Blade component in any of your Blade views like this:

<x-blesser.ui.form.textarea />

You can also pass values for the props you defined:

<x-blesser.ui.form.textarea
    rows="6"
    placeholder="Enter your comment here"
    id="comment"
    name="comment"
>This is some default text inside the textarea.</x-blesser.ui.form.textarea>

And you can add other HTML attributes directly, which will be merged thanks to `{{ $attributes->merge([...]) }}`:

<x-blesser.ui.form.textarea
    id="custom-id"****
    name="custom-name"
    required
    class="custom-class"
/>

```

### Select

You can now use this component in any of your Blade views like this:

**Example 1: Basic usage**

````html
<x-custom-select
    label="دسته بندی را انتخاب کنید"
    name="category"
    :options="['F' => 'گزینه اول', 'S' => 'گزینه دوم', 'T' => 'گزینه سوم']"
    selected="S"
/>
````

**Example 2: With a placeholder and different ID**

````html
<x-custom-select
    id="product-type-select"
    label="نوع محصول"
    name="product_type"
    placeholder="لطفا یک نوع را انتخاب کنید"
    :options="['Electronics', 'Books', 'Clothing']"
/>
````

**Example 3: Passing additional HTML attributes**

````html
@php
    $productOptions = [
        'laptop' => 'لپ تاپ',
        'mouse' => 'موس',
        'keyboard' => 'کیبورد'
    ];
@endphp

<x-custom-select
    label="محصول"
    name="product_id"
    :options="$productOptions"
    class="mt-4 border-blue-500"
    required
/>
````

Remember to adjust the `name` attribute as needed for your form handling logic.

### rate

```html
{{-- Basic usage with 5 stars --}}
<x-blesser.ui.form.rate name="product_rating" />

{{-- With a pre-selected value (e.g., 3 stars) --}}
<x-blesser.ui.form.rate name="product_feedback_rating" :value="3" />

{{-- With a different number of stars (e.g., 7 stars) --}}
<x-blesser.ui.form.rate name="service_rating" :maxRating="7" />

{{-- With a pre-selected value and custom attributes --}}
<x-blesser.ui.form.rate name="another_rating" :value="4" class="my-custom-rating-class" />
```
