<?php

namespace App\Data\Woo;

use App\Data\BaseData;

class CouponLineData extends BaseData
{
    public function __construct(
        public readonly ?int $id,
        public readonly ?string $code,
        public readonly ?string $discount,
        public readonly ?string $discountTax,
        /** @var \Illuminate\Support\Collection<MetaDataData>|null */
        public readonly mixed $metaData,
    ) {}

    protected static function casts(): array
    {
        return [
            'id'          => 'int',
            'code'        => 'string',
            'discount'    => 'string',
            'discountTax' => 'string',
            'metaData'    => 'collection:' . MetaDataData::class,
        ];
    }
}
