<?php

namespace App\Data\Woo;

use App\Data\BaseData;
use App\Data\Woo\TagData;
use App\Data\Woo\ImageData;
use App\Data\Woo\CategoryData;
use App\Data\Woo\DownloadData;
use App\Data\Woo\MetaDataData;
use Illuminate\Support\Carbon;
use App\Data\Woo\DimensionsData;

class ProductData extends BaseData
{
    public function __construct(
        public readonly ?int $id,
        public readonly ?string $name,
        public readonly ?string $slug,
        public readonly ?string $permalink,
        public readonly ?Carbon $dateCreated,
        public readonly ?Carbon $dateCreatedGmt,
        public readonly ?Carbon $dateModified,
        public readonly ?Carbon $dateModifiedGmt,
        public readonly ?string $type,
        public readonly ?string $status,
        public readonly ?bool $featured,
        public readonly ?string $catalogVisibility,
        public readonly ?string $description,
        public readonly ?string $shortDescription,
        public readonly ?string $sku,
        public readonly ?string $globalUniqueId,
        public readonly ?string $price,
        public readonly ?string $regularPrice,
        public readonly ?string $salePrice,
        public readonly ?Carbon $dateOnSaleFrom,
        public readonly ?Carbon $dateOnSaleFromGmt,
        public readonly ?Carbon $dateOnSaleTo,
        public readonly ?Carbon $dateOnSaleToGmt,
        public readonly ?string $priceHtml,
        public readonly ?bool $onSale,
        public readonly ?bool $purchasable,
        public readonly ?int $totalSales,
        public readonly ?bool $virtual,
        public readonly ?bool $downloadable,
        /** @var \Illuminate\Support\Collection<DownloadData>|null */
        public readonly mixed $downloads,
        public readonly ?int $downloadLimit,
        public readonly ?int $downloadExpiry,
        public readonly ?string $externalUrl,
        public readonly ?string $buttonText,
        public readonly ?string $taxStatus,
        public readonly ?string $taxClass,
        public readonly ?bool $manageStock,
        public readonly ?int $stockQuantity,
        public readonly ?string $stockStatus,
        public readonly ?string $backorders,
        public readonly ?bool $backordersAllowed,
        public readonly ?bool $backordered,
        public readonly ?bool $soldIndividually,
        public readonly ?string $weight,
        public readonly ?DimensionsData $dimensions,
        public readonly ?bool $shippingRequired,
        public readonly ?bool $shippingTaxable,
        public readonly ?string $shippingClass,
        public readonly ?int $shippingClassId,
        public readonly ?bool $reviewsAllowed,
        public readonly ?string $averageRating,
        public readonly ?int $ratingCount,
        /** @var int[]|null */
        public readonly ?array $relatedIds,
        /** @var int[]|null */
        public readonly ?array $upsellIds,
        /** @var int[]|null */
        public readonly ?array $crossSellIds,
        public readonly ?int $parentId,
        public readonly ?string $purchaseNote,
        /** @var \Illuminate\Support\Collection<CategoryData>|null */
        public readonly mixed $categories,
        /** @var \Illuminate\Support\Collection<TagData>|null */
        public readonly mixed $tags,
        /** @var \Illuminate\Support\Collection<ImageData>|null */
        public readonly mixed $images,
        /** @var \Illuminate\Support\Collection<AttributeData>|null */
        public readonly mixed $attributes,
        /** @var \Illuminate\Support\Collection<DefaultAttributeData>|null */
        public readonly mixed $defaultAttributes,
        /** @var int[]|null */
        public readonly ?array $variations,
        /** @var int[]|null */
        public readonly ?array $groupedProducts,
        public readonly ?int $menuOrder,
        /** @var \Illuminate\Support\Collection<MetaDataData>|null */
        public readonly mixed $metaData,
    ) {}

    protected static function casts(): array
    {
        return [
            'id'                   => 'int',
            'name'                 => 'string',
            'slug'                 => 'string',
            'permalink'            => 'string',

            'dateCreated'          => 'datetime',
            'dateCreatedGmt'       => 'datetime',
            'dateModified'         => 'datetime',
            'dateModifiedGmt'      => 'datetime',

            'type'                 => 'string',
            'status'               => 'string',
            'featured'             => 'bool',
            'catalogVisibility'    => 'string',
            'description'          => 'string',
            'shortDescription'     => 'string',
            'sku'                  => 'string',
            'globalUniqueId'       => 'string',

            'price'                => 'string',
            'regularPrice'         => 'string',
            'salePrice'            => 'string',

            'dateOnSaleFrom'       => 'datetime',
            'dateOnSaleFromGmt'    => 'datetime',
            'dateOnSaleTo'         => 'datetime',
            'dateOnSaleToGmt'      => 'datetime',

            'priceHtml'            => 'string',
            'onSale'               => 'bool',
            'purchasable'          => 'bool',
            'totalSales'           => 'int',

            'virtual'              => 'bool',
            'downloadable'         => 'bool',
            'downloads'            => 'collection:' . DownloadData::class,
            'downloadLimit'        => 'int',
            'downloadExpiry'       => 'int',

            'externalUrl'          => 'string',
            'buttonText'           => 'string',

            'taxStatus'            => 'string',
            'taxClass'             => 'string',

            'manageStock'          => 'bool',
            'stockQuantity'        => 'int',
            'stockStatus'          => 'string',
            'backorders'           => 'string',
            'backordersAllowed'    => 'bool',
            'backordered'          => 'bool',
            'soldIndividually'     => 'bool',

            'weight'               => 'string',
            'dimensions'           => 'object:' . DimensionsData::class,

            'shippingRequired'     => 'bool',
            'shippingTaxable'      => 'bool',
            'shippingClass'        => 'string',
            'shippingClassId'      => 'int',

            'reviewsAllowed'       => 'bool',
            'averageRating'        => 'string',
            'ratingCount'          => 'int',

            'relatedIds'           => 'array',
            'upsellIds'            => 'array',
            'crossSellIds'         => 'array',

            'parentId'             => 'int',
            'purchaseNote'         => 'string',

            'categories'           => 'collection:' . CategoryData::class,
            'tags'                 => 'collection:' . TagData::class,
            'images'               => 'collection:' . ImageData::class,
            'attributes'           => 'collection:' . AttributeData::class,
            'defaultAttributes'    => 'collection:' . DefaultAttributeData::class,

            'variations'           => 'array',
            'groupedProducts'      => 'array',

            'menuOrder'            => 'int',
            'metaData'             => 'collection:' . MetaDataData::class,
        ];
    }

    protected static function rules(): array
    {
        return [
            'type'            => ['nullable', 'in:simple,grouped,external,variable'],
            'status'          => ['nullable', 'in:draft,pending,private,publish'],
            'catalog_visibility' => ['nullable', 'in:visible,catalog,search,hidden'],
            'stock_status'    => ['nullable', 'in:instock,outofstock,onbackorder'],
            'backorders'      => ['nullable', 'in:no,notify,yes'],
            'tax_status'      => ['nullable', 'in:taxable,shipping,none'],
        ];
    }
}
