<?php

namespace App\Data\Woo;

use App\Data\BaseData;

class TaxLineData extends BaseData
{
    public function __construct(
        public readonly ?int $id,
        public readonly ?string $rateCode,
        public readonly ?int $rateId,
        public readonly ?string $label,
        public readonly ?bool $compound,
        public readonly ?string $taxTotal,
        public readonly ?string $shippingTaxTotal,
        /** @var \Illuminate\Support\Collection<MetaDataData>|null */
        public readonly mixed $metaData,
    ) {}

    protected static function casts(): array
    {
        return [
            'id'               => 'int',
            'rateCode'         => 'string',
            'rateId'           => 'int',
            'label'            => 'string',
            'compound'         => 'bool',
            'taxTotal'         => 'string',
            'shippingTaxTotal' => 'string',
            'metaData'         => 'collection:' . MetaDataData::class,
        ];
    }
}
