<?php

use App\Cache\Contracts\Cacheable;

if (!function_exists('cacheable')) {
    /**
     * Get an instance of a cacheable class and optionally perform a method on it.
     *
     * @param string|Cacheable $classOrInstance
     * @return Cacheable
     */
    function cacheable(string|Cacheable $classOrInstance): Cacheable
    {
        if (is_string($classOrInstance)) {
            $cacheable = app($classOrInstance); // Resolve from container
        } else {
            $cacheable = $classOrInstance;
        }

        if (! $cacheable instanceof Cacheable) {
            throw new InvalidArgumentException("Class must implement Cacheable interface");
        }

        return $cacheable;
    }
}
