<?php

namespace App\Http\Actions\Admin\Shop;

use Illuminate\Http\Request;

class RegisterWooCommerceShop
{
    public function __invoke(Request $request)
    {
        $validated =  $request->validate(
            [
                'consumer_key' => 'required',
                'consumer_secret' => 'required',
                'woo_url' => 'required',
            ]
        );

        $validated['consumer_key'] = encrypt($validated['consumer_key']);
        $validated['consumer_secret'] = encrypt($validated['consumer_secret']);

        auth()->user()->shop()->update($validated);


        return back()->sweetalert()->success(__('Your WooCommerce shop registered successfully'));
    }
}
