<?php

namespace App\Http\Actions;

use Illuminate\View\View;
use App\Models\PreInvoice;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class PreInvoiceQuoteSelectionAction
{
    public function __invoke(Request $request)
    {
        $preInvoice =PreInvoice::findOrFail($request->pre_invoice);

        Gate::authorize(ability: 'update', arguments: $preInvoice);

        $preInvoice->update(['selected_quote_id' => $request->quote]);

        return back()->with('success', __('quote selected successfully'));
    }
}
