<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Comment;
use App\Services\SweetAlert;
use Illuminate\Http\Request;

class CommentController extends Controller
{
    public function index(Request $request)
    {
        $model = "App\\Models\\" . $request->query('model');

        $comments = Comment::where('commentable_type', $model)
            ->with(['user', 'commentable'])
            ->latest()
            ->paginate(20);

        return view('pages.admin.comments', compact('comments'));
    }
    public function updateStatus(Request $request, Comment $comment)
    {
        $comment->update([
            'status' => $request->status,
        ]);

        return redirect()->back()->with('sweetalert', SweetAlert::success(
            __('Success'),
            __('Comment status updated successfully'),
        ));
    }
}
