<?php

namespace App\Http\Controllers\Admin\Delivery;

use App\Http\Controllers\Controller;
use App\Models\DeliveryTime;
use App\Models\DeliveryTimeException;
use Illuminate\Http\Request;
use Illuminate\Routing\RouteRegistrar;

class DeliveryTimeExceptionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request, DeliveryTime $time)
    {
        $deliveryTimeExceptions = DeliveryTimeException::when($request->time_id, function ($query, $time_id) {
            $query->where('delivery_time_id', $time_id);
        })->get();

        return view('pages.admin.delivery.time-exception.index', compact('deliveryTimeExceptions', 'time'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request, DeliveryTime $time)
    {
        return view('pages.admin.delivery.time-exception.create', ['time' => $time]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'delivery_time_id' => 'required',
            'date' => 'required',
        ]);

        $exception = DeliveryTimeException::create($validated);

        return redirect()->route('admin.delivery.time.exceptions.index', $exception->delivery_time_id)->sweetalert()->success(__('Time Exception added successfully'));
    }

    /**
     * Display the specified resource.
     */
    public function show(DeliveryTimeException $exception)
    {
        return view('pages.admin.delivery.time-exception.show', compact('exception'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Request $request, DeliveryTimeException $exception)
    {
        return view('pages.admin.delivery.time-exception.edit', [
            'time_id' => $request->time_id,
            'delivery_time_exception' => $exception
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, DeliveryTimeException $exception)
    {
        $validated = $request->validate([
            'delivery_time_id' => 'required',
            'date' => 'required',
        ]);

        $exception->update($validated);

        return redirect()->route('admin.delivery.time.exceptions.index', ['time_id' => $exception->delivery_time_id])->sweetalert()->success(__('Time Exception updated successfully'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(DeliveryTimeException $exception)
    {
        $time_id = $exception->delivery_time_id;
        try {
            $exception->delete();
            return redirect()->route('admin.delivery.time.exceptions.index', ['time' => $time_id])->sweetalert()->success(__('Time Exception Deleted successfully'));
        } catch (\Throwable $th) {
            return redirect()->route('admin.delivery.time.exceptions.index', ['time' => $time_id])->sweetalert()->failure(__('Something went wrong. try again'));
        }
    }
}
