<?php

namespace App\Http\Controllers\Admin\Grapesjs;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class AssetUploadController extends Controller
{
    public function store(Request $request)
    {
        // Get all files from the request
        $files = $request->allFiles();

        if (empty($files)) {
            return response()->json([
                'error' => 'No files found for upload'
            ], 422);
        }

        // Create validation rules for each file
        $rules = [];
        foreach ($files as $key => $file) {
            $rules[$key] = 'required|file|max:4096|mimes:jpg,jpeg,png,webp,svg,gif,pdf';
        }

        $validator = Validator::make($files, $rules);

        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()->first()
            ], 422);
        }

        $uploadedUrls = [];

        // Process each uploaded file
        foreach ($files as $file) {
            $path = $file->store('grapes-assets', 'public_upload');
            $uploadedUrls[] = Storage::disk('public_upload')->url($path);
        }

        return ['data' => $uploadedUrls];
    }
}
