<?php

namespace App\Http\Controllers\Admin;

use Carbon\Carbon;
use App\Models\Page;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class PagePublishController extends Controller
{
    public function publish(Request $request, Page $page)
    {
        // $this->authorize('update', $page);

        $page->update([
            'is_published'  => true,
            'published_at'  => Carbon::now(),
            'published_html' => ($page->content ?? '') . '<style>' . ($page->css ?? '') . '</style>',
        ]);

        return back()->with('ok', 'Published!');
    }
}
