<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Post;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class PostController extends Controller
{
    public function index()
    {
        $posts = Post::latest()->paginate(10);
        return view('pages.admin.blog.index', compact('posts'));
    }

    public function create()
    {
        return view('pages.admin.blog.create');
    }

    public function show()
    {
        $posts = Post::latest()->paginate(10);
        return view('pages.admin.blog.index', compact('posts'));
    }

    public function store(Request $request)
    {
        $data = $this->validateRequest($request);

        // Handle file uploads
        if ($request->hasFile('img')) {
            $data['img'] = $request->file('img')->store('post/images', 'public_upload');
        }

        if ($request->hasFile('video')) {
            $data['video'] = $request->file('video')->store('post/videos', 'public_upload');
        }

        $data['slug'] = Str::slug($request->title);
        $data['user_id'] = auth()->user()->id;

        $post = Post::create($data);

        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                // $data['files'][] = $file->store('post/files', 'public_upload');
                $files[] = $post->file()->upload($file, [
                    'path' => 'post/files',
                    'disk' => 'public_upload',
                ]);
            }
        }

        return redirect()->route('admin.post.index')->with('success', 'Post created successfully.');
    }


    public function edit(Post $post)
    {
        return view('pages.admin.blog.edit', compact('post'));
    }

    public function update(Request $request, Post $post)
    {
        $data = $this->validateRequest($request);
        $data['slug'] = Str::slug($request->title);
        $data['user_id'] = auth()->id();

        // Handle new file uploads
        if ($request->hasFile('img')) {
            $data['img'] = $request->file('img')->store('post/images', 'public_upload');
        }

        if ($request->hasFile('video')) {
            $data['video'] = $request->file('video')->store('post/videos', 'public_upload');
        }

        $post->update($data);

        return redirect()->route('admin.post.index')->with('success', 'Post updated successfully.');
    }

    public function destroy(Post $post)
    {
        $post->delete();
        return redirect()->route('admin.post.index')->with('success', 'Post deleted successfully.');
    }

    protected function validateRequest(Request $request)
    {
        return $request->validate([
            'author' => 'nullable|string|max:255',
            'title' => 'required|string|max:255',
            'content' => 'nullable|string',
            'short_desc' => 'nullable|string|max:500',
            'comment_status' => 'nullable',
            'slug' => 'nullable|string|max:255',
            'price' => 'nullable|numeric',
            'password' => 'nullable|string|max:255',
            'type' => 'nullable|string|max:100',
            'name' => 'nullable|string|max:255',
            'layout' => 'nullable|string|max:255',
            'status' => 'nullable|in:draft,published',
            'img' => 'nullable',
            'video' => 'nullable',
        ]);
    }
}
