<?php

namespace App\Http\Controllers\Admin\WooCommerce;

use App\Data\Woo\CustomerData;
use Illuminate\Http\Request;

class WooCustomerController extends WooBaseController
{
    public function list(Request $request)
    {
        $since   = $request->string('since')->toString();  // e.g. ISO8601 or null
        $page    = (int) $request->input('page', 1);
        $perPage = (int) $request->input('per_page', 20);
        $status  = $request->input('status');              // publish|draft|...

        $key = $this->cacheKey('customer', compact('since', 'page', 'perPage', 'status'));


        if ($request->boolean('refresh')) {
            $this->forget($key);
        }

        $customers = $this->remember($key, $this->defaultTtl(), function () use ($since, $page, $perPage, $status) {
            $apiResult = $this->wooClient->customersSince();
            return CustomerData::collection($apiResult);
        });


        return view('pages.admin.woo-commerce.customer.list', compact('customers'));
    }
}
