<?php

namespace App\Livewire\User;

use Livewire\Attributes\Url;
use Livewire\Component;

class PanelTabs extends Component
{
    #[Url]
    public $tab = 'dashboard';

    protected $listeners = [
        'showDashboardTab' => 'showDashboardTab',
        'showAddressTab' => 'showAddressTab',
        'showFavoriteTab' => 'showFavoriteTab',
        'showOrderTab' => 'showOrderTab',
        'showProfileTab' => 'showProfileTab',
        'showNotificationTab' => 'showNotificationTab',
        'showRecentTab' => 'showRecentTab',
    ];

    public function showDashboardTab()
    {
        $this->tab = 'dashboard';
    }

    public function showNotificationTab()
    {
        $this->tab = 'notification';
    }

    public function showAddressTab()
    {
        $this->tab = 'address';
    }

    public function showFavoriteTab()
    {
        $this->tab = 'favorite';
    }

    public function showOrderTab()
    {
        $this->tab = 'order';
    }

    public function showProfileTab()
    {
        $this->tab = 'profile';
    }

    public function showRecentTab()
    {
        $this->tab = 'recent';
    }

    public function render()
    {
        return view('livewire.user.panel-tabs');
    }
}
