<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class CategoryAttribute extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'category_id',
        'label',
        'type',
        'name',
        'default_value',
        'is_required',
        'is_filterable',
        'filter_type',
        'is_price_effective',
        'validation',
        'deleted_at',
    ];

    /**
     * The part below is for this model relationships
     */
    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    public function items(): HasMany
    {
        return $this->hasMany(CategoryAttributeItem::class, 'category_attribute_id');
    }
    /**
     * The above is for this model relationships
     */
}
