<?php

namespace App\Models;

use App\Enums\CommentStatusEnum;
use Illuminate\Database\Eloquent\Model;

class Comment extends Model
{
    protected $fillable = [
        'id',
        'name',
        'commentable_id',
        'commentable_type',
        'user_id',
        'parent',
        'vote_up',
        'vote_down',
        'good_point',
        'bad_point',
        'rate',
        'seller_satisfactory',
        'status',
        'content',
        'data',
    ];

    protected $casts = [
        'status' => CommentStatusEnum::class,
    ];

    /**
     * The part below is for this model relationships
     */

     public function user()
     {
            return $this->belongsTo(User::class);
     }
    public function commentable()
    {
        return $this->morphTo();
    }
    /**
     * The above is for this model relationships
     */
}
