<?php

namespace App\Models;

use Illuminate\Support\Collection;
use Illuminate\Database\Eloquent\Model;

class Option extends Model
{
    protected $fillable = [
        'env',
        'group',
        'key',
        'value',
        'data',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'data' => 'array',
        ];
    }


    public static function getByKey(string $key, $first = false): Collection|Option|null
    {
        if ($first === true) {
            return app('web_options')->where('key', $key)->first();
        }
        return app('web_options')->where('key', $key)->values();
    }

    public static function getValue(string $key, $default = null)
    {
        return optional(static::getByKey($key)->first())->value ?? $default;
    }

    /**
     * Scope a query to only include options where env is 'web'.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeWeb($query)
    {
        return $query->where('env', 'web');
    }

    public function scopeKey($query, $key)
    {
        return $query->where('key', $key);
    }
}
