<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ProductInventory extends Model
{
    protected $fillable = [
        'product_id',
        'user_id',
        'shop_id',
        'name',
        'weight',
        'size',
        'color',
        'status',
        'price',
        'inventory',
    ];

    /**
     * The part below is for this model relationships
     */
    public function variant(): HasMany
    {
        return $this->hasMany(ProductInventoryVariant::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class , 'product_id');
    }

    public function seller()
    {
        return $this->belongsTo(Shop::class, 'shop_id');
    }
    /**
     * The above is for this model relationships
     */
}
