<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Warehouse extends Model
{
    protected $fillable = ['shop_id', 'name', 'code', 'is_active', 'address'];

    protected $casts = [
        'address' => 'array',
        'is_active' => 'boolean',
    ];

    public function shop()
    {
        return $this->belongsTo(Shop::class);
    }

    public function inventories()
    {
        return $this->hasMany(WarehouseInventory::class);
    }


    public function scopeForUser($query, $user)
    {
        return $user->hasRole('Admin')
            ? $query
            : $query->where('shop_id', $user->shop->id);
    }
}
