<?php

namespace App\PageBuilder\Components;

use App\PageBuilder\Contracts\PageComponent;

class ImageGrid implements PageComponent
{
    public static function name(): string
    {
        return 'image-grid';
    }

    public static function label(): string
    {
        return 'Responsive Image Grid';
    }

    public static function fields(): array
    {
        return [
            [
                'type' => 'repeater',
                'name' => 'images',
                'label' => 'Images',
                'fields' => [
                    ['name' => 'src', 'type' => 'image', 'label' => 'Image URL'],
                    ['name' => 'alt', 'type' => 'text', 'label' => 'Alt text (optional)'],
                    ['name' => 'link', 'type' => 'text', 'label' => 'Link (optional)'],
                ]
            ]
        ];
    }

    public function render(array $settings): string
    {
        $images = $settings['images'] ?? [];
        return view('components.blesser.ui.banner', compact('images'))->render();
    }

    public static function view(): string
    {
        return 'components.blesser.ui.banner'; // Blade component path
    }

    public function preview(array $settings): string
    {
        return $this->render($settings); // Same as render for now
    }
}
