<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Warehouse;

class WarehousePolicy
{
    public function viewAny(User $user): bool
    {
        return $user->hasRole('Admin') || $user->hasRole('Shop');
    }

    public function view(User $user, Warehouse $warehouse): bool
    {
        return $user->hasRole('Admin') || (int)$warehouse->shop_id === (int)$user->shop->id;
    }

    public function create(User $user): bool
    {
        return $user->hasRole('Admin') || $user->hasRole('Shop');
    }

    public function update(User $user, Warehouse $warehouse): bool
    {
        return $this->view($user, $warehouse);
    }

    public function delete(User $user, Warehouse $warehouse): bool
    {
        return $this->view($user, $warehouse);
    }
}
