<?php

namespace App\Providers;

use App\Events\UserLoggedIn;
use Illuminate\Auth\Events\Login;
use App\Services\Models\CartService;
use Illuminate\Support\Facades\Event;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\ServiceProvider;

class CartServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // When user logs in (existing user)
        Event::listen(UserLoggedIn::class, function ($event) {
            app(CartService::class)->mergeGuestCartIntoUser();
        });
        Event::listen(Login::class, function ($event) {
            app(CartService::class)->mergeGuestCartIntoUser();
        });

        // When user registers (new account)
        Event::listen(Registered::class, function ($event) {
            app(CartService::class)->mergeGuestCartIntoUser();
        });
    }
}
