<?php

namespace App\Services;

use App\Exceptions\OtpException;
use App\Models\Otp;

class OtpService
{
    public static function sendOtp(string $phoneNumber): bool
    {
        // Prevent multiple OTP requests within 2 minutes
        $lastOtp = Otp::latestActiveCodeForPhone($phoneNumber);
        if ($lastOtp && $lastOtp->created_at->diffInMinutes() < 2) {
            throw new OtpException(__('Please try again after 2 minutes'), 400);
        }

        // Prevent excessive requests (max 6 per hour)
        if (Otp::lastHourActiveCodeForPhone($phoneNumber)->count() > 6) {
            throw new OtpException(__('You have reached the request limit, please try again after 1 hour'), 400);
        }

        // Generate and store OTP
        $otp = Otp::create(['phone' => $phoneNumber]);

        // Send OTP via SMS
        (new FarazSmsService)->sendByPattern($otp->phone, 'activation-code', ['token' => $otp->code]);

        return true;
    }

    public static function verifyOtp(string $phoneNumber, string $otpCode): bool
    {
        $codeFromDb = Otp::latestActiveCodeForPhone($phoneNumber);

        if ($codeFromDb != null && ($otpCode == $codeFromDb->code)) {
            return true;
        }

        return false;
    }
}
