<?php

namespace App\Services\SEO;

use App\Services\SEO\MetaManager;
use Illuminate\Support\HtmlString;
use App\Services\SEO\SchemaManager;

class SeoManager
{

    protected MetaManager $meta;
    protected SchemaManager $schema;

    protected string $title = '';
    public function __construct()
    {
        $this->meta = new MetaManager();
        $this->setTitle();
    }

    public function meta(): MetaManager
    {
        return $this->meta;
    }
    public function schema(): SchemaManager
    {
        return $this->schema;
    }

    public function setTitle(?string $title = ''): self
    {
        $siteName = getSiteName() ?? '';
        $this->title = " $siteName | $title";
        $this->meta->set('title', $title);
        return $this;
    }
    public function getTitle(): string
    {
        return $this->title;
    }
}
