<?php

namespace App\Services\Woo;

use Illuminate\Support\Facades\Http;
use Illuminate\Http\Client\PendingRequest;
use Illuminate\Http\Client\Response;
use Throwable;

final class WooCredentials
{
    public function __construct(
        public readonly string $baseUrl,
        public readonly string $consumerKey,
        public readonly string $consumerSecret,
        public readonly bool   $allowQueryAuthFallback = false // only for local http
    ) {}
    public function isHttps(): bool
    {
        return str_starts_with(strtolower($this->baseUrl), 'https://');
    }
}
