<?php

namespace App\View\Components\Blesser\Element;

use App\Models\Category;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class CategoryList extends Component
{
    public $title;

    public $categories;
    /**
     * Create a new component instance.
     */
    public function __construct($title)
    {
        $this->title = $title;
        $this->categories = Category::where('parent_id', 0)->get();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.blesser.element.category-list');
    }
}
