<?php

namespace App\View\Components\Syndron;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class AdminNavigationMenu extends Component
{
    public $items = [];

    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        $this->items = $this->getMenuItems();
    }


    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.syndron.admin-navigation-menu');
    }

    private function getMenuItems(): array
    {
        return [
            [
                'name' => __('Dashboard'),
                'is_url' => false,
                'route' => 'admin.dashboard',
                'permission' => 'dashboard.view',
                'url' => null,
                'icon' => 'bx bx-home-alt',
                'children' => [],
            ],
            [
                'name' => __('Dashboard'),
                'is_url' => false,
                'route' => 'admin.shop.dashboard',
                'permission' => 'dashboard.shop.view',
                'url' => null,
                'icon' => 'bx bx-home-alt',
                'children' => [],
            ],
            [
                'name' => __('Shop Setting'),
                'is_url' => false,
                'route' => 'admin.shop.setting',
                'permission' => 'admin.shop.profile.update',
                'url' => null,
                'icon' => 'bx bx-home-alt',
                'children' => [],
            ],

        ];
    }
}
