<?php

namespace Database\Factories;

use App\Models\Shop;
use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Shop>
 */
class ShopFactory extends Factory
{
    protected $model = Shop::class;
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $name = $this->faker->company;

        return [
            'user_id' => User::factory(), // or use a static user_id for tests
            'name' => $name,
            'slug' => Str::slug($name) . '-' . Str::random(4),
            'logo' => 'shops/logos/' . $this->faker->image('public/storage/shops/logos', 200, 200, null, false),
            'description' => $this->faker->paragraph,
            'phone' => $this->faker->phoneNumber,
            'email' => $this->faker->companyEmail,
            'address' => $this->faker->address,
            'city' => $this->faker->city,
            'state' => $this->faker->state,
            'postal_code' => $this->faker->postcode,
            'country' => 'IR',
            'is_approved' => true,
            'approved_at' => now(),
        ];
    }
}
