<?php

use App\Enums\ProductStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained();
            $table->foreignId('category_id')->nullable()->constrained();
            $table->foreignId('brand_id')->nullable()->constrained()->nullOnDelete();
            $table->string('title');
            $table->string('code')->nullable();
            $table->string('slug', 500);
            $table->string('short_description')->nullable();
            $table->longText('content')->nullable();
            $table->unsignedInteger('inventory')->nullable()->default(0);
            $table->string('weight')->nullable();
            $table->string('length')->nullable();
            $table->string('width')->nullable();
            $table->string('height')->nullable();
            $table->unsignedBigInteger('price')->nullable();
            $table->unsignedBigInteger('discount_price')->nullable();
            $table->string('off_rate')->nullable();
            $table->boolean('second_hand')->nullable()->default(0)->nullable();
            $table->boolean('consumable')->nullable()->default(0)->nullable();
            $table->enum('status', array_column(ProductStatusEnum::cases(), 'value'));
            $table->string('brand_img', 1000);
            $table->json('attributes')->nullable();
            $table->auditable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
