<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_inventories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained();
            $table->foreignId('user_id')->constrained();
            $table->foreignId('shop_id')->constrained();
            $table->string('name')->nullable();
            $table->string('weight')->nullable();
            $table->string('size')->nullable();
            $table->string('color')->nullable();
            $table->string('status')->nullable()->default('available');
            $table->unsignedBigInteger('price')->nullable();
            $table->unsignedInteger('inventory')->nullable()->default(0);
            $table->auditable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_inventories');
    }
};
