<?php

use App\Enums\WalletTransactionTypeEnum;
use App\Enums\WalletTypeEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wallets', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->decimal('balance', 12, 3)->nullable()->default(0);
            $table->decimal('blocked', 12, 3)->nullable()->default(0);
            $table->enum('type', array_column(WalletTypeEnum::cases(), 'value'));
            $table->timestamps();
        });

        Schema::create('wallet_transactions', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique()->nullable()->default(DB::raw('(UUID())'));
            $table->foreignId('wallet_id')->constrained()->cascadeOnDelete();
            $table->decimal('amount', 12, 3);
            $table->enum('type', WalletTransactionTypeEnum::values());
            $table->string('description')->nullable();
            $table->decimal('balance', 12, 3)->nullable()->default(0);
            $table->timestamps();
        });

        Schema::create('wallet_settlements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained();
            $table->foreignId('wallet_id')->constrained();
            $table->float('amount', 12, 2)->nullable()->default(0);
            $table->string('status')->nullable()->default('created by user');
            $table->string('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallets');
        Schema::dropIfExists('wallet_transactions');
        Schema::dropIfExists('wallet_settlements');
    }
};
