<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('cart_items', function (Blueprint $table) {
            $table->id();
            // nullable so guests don’t need a user_id
            $table->foreignId('cart_id')->constrained('carts')->onDelete('cascade');
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->foreignId('inventory_id')->nullable()->constrained('product_inventories')->onDelete('cascade');
            $table->foreignId('variant_id')->nullable()->constrained('product_inventory_variants')->onDelete('cascade');
            $table->foreignId('shop_id')->nullable()->constrained('shops')->onDelete('cascade');
            $table->json('variant')->nullable();

            $table->integer('quantity')->default(1);
            $table->decimal('price', 12, 2)->nullable(); // unit price at the time
            $table->decimal('total', 12, 2);
            $table->string('discount')->nullable();
            $table->string('coupon')->nullable();

            $table->json('options')->nullable();

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('cart_items');
    }
};
