<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('modules', function (Blueprint $table) {
            $table->id();

            $table->string('label')->nullable()->comment('name of the module. can be in any language');
            $table->string('name')->comment('name of the module. only in English and should be valid name same rule as php variable naming');

            $table->boolean('is_active')->default(0)->nullable();
            $table->boolean('is_paid')->default(0)->nullable();
            $table->boolean('is_free')->default(0)->nullable();

            $table->boolean('is_permanent')->default(0)->nullable();

            $table->dateTime('activated_at')->nullable();
            $table->dateTime('expire_at')->nullable();

            $table->json('requirements')->nullable();
            $table->json('options')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('modules');
    }
};
