<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quotes', function (Blueprint $table) {
            $table->id();

            $table->foreignId('pre_invoice_id')->constrained()->cascadeOnDelete();
            $table->foreignId('supplier_id')->constrained('shops')->cascadeOnDelete();

            // Summary info
            $table->unsignedBigInteger('total')->nullable();
            $table->string('currency', 10)->default('IRR');
            $table->string('status')->default('draft');

            // Supplier terms and notes
            $table->text('terms')->nullable();
            $table->text('notes')->nullable();

            $table->json('options')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quotes');
    }
};
