<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Artemis\Faq\Enums\QuestionStatusTypeEnum;

return new class extends Migration {
    public function up(): void
    {
        Schema::create(prefixedTable('questions'), function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('body');
            $table->foreignId('category_id')
                ->nullable()
                ->constrained(prefixedTable('categories'))
                ->onDelete('set null');
            $table->foreignId('best_answer_id')->nullable();
            $table->enum('status', QuestionStatusTypeEnum::toArray())->default(QuestionStatusTypeEnum::OPEN);
            $table->bigInteger('views')->default(0);
            
            $table->timestamps();
            $table->softDeletes();
        });
    }
    
    public function down(): void
    {
        Schema::dropIfExists(prefixedTable('questions'));
    }
};
