<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use App\Models\CategoryAttribute;
use App\Models\CategoryAttributeItem;

class CategoryAttributeSeeder extends Seeder
{
    public function run()
    {
        // Fetch categories
        $software = Category::where('name', 'Software')->first();
        $vpn = Category::where('name', 'VPN Services')->first();
        $ebooks = Category::where('name', 'Ebooks')->first();

        // Define attributes
        $attributes = [
            [
                'category' => $software,
                'label' => 'License Type',
                'type' => 'select',
                'name' => 'license_type',
                'default_value' => 'Single User',
                'is_required' => true,
                'is_filterable' => true,
                'filter_type' => 'select',
                'is_price_effective' => false,
                'validation' => 'in:Single User,Multi User,Enterprise',
                'items' => [
                    ['item_key' => 'single', 'item_value' => 'Single User'],
                    ['item_key' => 'multi', 'item_value' => 'Multi User'],
                    ['item_key' => 'enterprise', 'item_value' => 'Enterprise'],
                ],
            ],
            [
                'category' => $vpn,
                'label' => 'Duration (Months)',
                'type' => 'integer',
                'name' => 'duration_months',
                'default_value' => '12',
                'is_required' => true,
                'is_filterable' => true,
                'filter_type' => 'range',
                'is_price_effective' => true,
                'validation' => 'integer|min:1|max:36',
                'items' => null
            ],
            [
                'category' => $ebooks,
                'label' => 'Language',
                'type' => 'select',
                'name' => 'language',
                'default_value' => 'English',
                'is_required' => false,
                'is_filterable' => true,
                'filter_type' => 'select',
                'is_price_effective' => false,
                'validation' => 'in:English,French,German,Spanish',
                'items' => [
                    ['item_key' => 'en', 'item_value' => 'English'],
                    ['item_key' => 'fr', 'item_value' => 'French'],
                    ['item_key' => 'de', 'item_value' => 'German'],
                    ['item_key' => 'es', 'item_value' => 'Spanish'],
                ],
            ],
        ];

        foreach ($attributes as $attr) {
            $attribute = CategoryAttribute::create([
                'category_id' => $attr['category']->id,
                'label' => $attr['label'],
                'type' => $attr['type'],
                'name' => $attr['name'],
                'default_value' => $attr['default_value'],
                'is_required' => $attr['is_required'],
                'is_filterable' => $attr['is_filterable'],
                'filter_type' => $attr['filter_type'],
                'is_price_effective' => $attr['is_price_effective'],
                'validation' => $attr['validation'],
                'deleted_at' => null,
            ]);

            // Insert select options if available
            if ($attr['type'] === 'select' && is_array($attr['items'])) {
                foreach ($attr['items'] as $i => $item) {
                    CategoryAttributeItem::create([
                        'category_attribute_id' => $attribute->id,
                        'item_group' => $attr['name'],
                        'item_key' => $item['item_key'],
                        'item_value' => $item['item_value'],
                        'data' => null,
                    ]);
                }
            }
        }
    }
}
