<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Spatie\Permission\Models\Role;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = config('app.permissions');
        $adminPermissions = config('app.admin_default_permission');
        $shopPermissions = config('app.shop_default_permission');

        Permission::query()->delete();
        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        Role::where('name', 'Admin')->first()->givePermissionTo($adminPermissions);
        Role::where('name', 'Shop')->first()->givePermissionTo($shopPermissions);
    }
}
