<?php

namespace Database\Seeders\Ui;

use App\Models\Option;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class FooterSectionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Option::insert([
            [
                'env' => 'web',
                'group' => 'footer-first-section',
                'key' => 'column-1',
                'value' => 'برندهای پیشنهادی',
                'data' => json_encode([
                    'links' => [
                        ['label' => 'کفش نایک', 'url' => '/nike'],
                        ['label' => 'لباس زارا', 'url' => '/zara']
                    ]
                ]),
            ],
            [
                'env' => 'web',
                'group' => 'footer-first-section',
                'key' => 'column-2',
                'value' => 'دسته‌های پیشنهادی',
                'data' => json_encode([
                    'links' => [
                        ['label' => 'لباس مردانه', 'url' => '/men-clothing'],
                        ['label' => 'کفش زنانه', 'url' => '/women-shoes']
                    ]
                ]),
            ],
            [
                'env' => 'web',
                'group' => 'footer-first-section',
                'key' => 'column-3',
                'value' => 'دسترسی سریع',
                'data' => json_encode([
                    'links' => [
                        ['label' => 'تماس با ما', 'url' => '/contact'],
                        ['label' => 'سوالات متداول', 'url' => '/faq']
                    ]
                ]),
            ],
            [
                'env' => 'web',
                'group' => 'footer-first-section',
                'key' => 'column-4',
                'value' => 'نماد اعتماد',
                'data' => json_encode([
                    'images' => [
                        ['src' => '/images/symbol1.png', 'alt' => 'نماد اعتماد'],
                        ['src' => '/images/symbol2.png', 'alt' => 'نماد دیگر']
                    ]
                ]),
            ],
        ]);
    }
}
