$(function () {
    "use strict";

    // new PerfectScrollbar(".app-container"),
    // new PerfectScrollbar(".header-message-list"),
    // new PerfectScrollbar(".header-notifications-list"),

    // Mobile search bar toggle
    $(".mobile-search-icon").on("click", function () {
        $(".search-bar").addClass("full-search-bar");
    });
    $(".search-close").on("click", function () {
        $(".search-bar").removeClass("full-search-bar");
    });

    // Sidebar toggles
    $(".mobile-toggle-menu").on("click", function () {
        $(".wrapper").addClass("toggled");
    });

    $(".toggle-icon").click(function () {
        if ($(".wrapper").hasClass("toggled")) {
            $(".wrapper").removeClass("toggled");
            $(".sidebar-wrapper").unbind("hover");
        } else {
            $(".wrapper").addClass("toggled");
            $(".sidebar-wrapper").hover(function () {
                $(".wrapper").addClass("sidebar-hovered");
            }, function () {
                $(".wrapper").removeClass("sidebar-hovered");
            });
        }
    });

    // Back to top button
    $(window).on("scroll", function () {
        $(this).scrollTop() > 300 ? $(".back-to-top").fadeIn() : $(".back-to-top").fadeOut();
    });
    $(".back-to-top").on("click", function () {
        $("html, body").animate({ scrollTop: 0 }, 600);
        return false;
    });

    // Active menu item logic
    $(function () {
        let e = window.location;
        let o = $(".metismenu li a").filter(function () {
            return this.href == e;
        }).parent().addClass("mm-active");
        while (o.is("li")) {
            o = o.parent().addClass("mm-show").parent().addClass("mm-active");
        }
    });

    // Init metis menu
    $("#menu").metisMenu();

    // Chat & email toggles
    $(".chat-toggle-btn").on("click", function () {
        $(".chat-wrapper").toggleClass("chat-toggled");
    });
    $(".chat-toggle-btn-mobile").on("click", function () {
        $(".chat-wrapper").removeClass("chat-toggled");
    });

    $(".email-toggle-btn").on("click", function () {
        $(".email-wrapper").toggleClass("email-toggled");
    });
    $(".email-toggle-btn-mobile").on("click", function () {
        $(".email-wrapper").removeClass("email-toggled");
    });

    $(".compose-mail-btn").on("click", function () {
        $(".compose-mail-popup").show();
    });
    $(".compose-mail-close").on("click", function () {
        $(".compose-mail-popup").hide();
    });

    // Load saved theme settings
    function loadThemeSettings() {
        const savedTheme = localStorage.getItem('admin-theme');
        if (savedTheme) {
            $("html").attr("class", savedTheme);
            $(".dark-mode-icon i").attr("class", savedTheme === 'light-theme' ? "bx bx-moon" : "bx bx-sun");
        }

        const savedHeaderColor = localStorage.getItem('headerColor');
        if (savedHeaderColor) {
            $("html").removeClass(function (index, className) {
                return (className.match(/(^|\s)headercolor\S+/g) || []).join(' ');
            });
            $("html").addClass(savedHeaderColor);
        }

        const savedSidebarColor = localStorage.getItem('sidebarColor');
        if (savedSidebarColor) {
            $("html").removeClass(function (index, className) {
                return (className.match(/(^|\s)sidebarcolor\S+/g) || []).join(' ');
            });
            $("html").addClass(savedSidebarColor);
        }
    }

    loadThemeSettings();

    // Dark/Light Mode toggle
    $(".dark-mode").on("click", function () {
        const icon = $(".dark-mode-icon i");
        const isDark = icon.hasClass("bx-sun");
        icon.attr("class", isDark ? "bx bx-moon" : "bx bx-sun");
        const newTheme = isDark ? "light-theme" : "dark-theme";
        $("html").attr("class", newTheme);
        localStorage.setItem('admin-theme', newTheme);
    });

    // Switcher panel toggle
    $(".switcher-btn").on("click", function () {
        $(".switcher-wrapper").toggleClass("switcher-toggled");
    });
    $(".switcher-menu-item").on("click", function () {
        $(".switcher-wrapper").toggleClass("switcher-toggled");
    });
    $(".close-switcher").on("click", function () {
        $(".switcher-wrapper").removeClass("switcher-toggled");
    });

    // Theme mode buttons
    $("#lightmode").on("click", function () {
        $("html").attr("class", "light-theme");
        localStorage.setItem('admin-theme', 'light-theme');
        $(".dark-mode-icon i").attr("class", "bx bx-moon");
    });
    $("#darkmode").on("click", function () {
        $("html").attr("class", "dark-theme");
        localStorage.setItem('admin-theme', 'dark-theme');
        $(".dark-mode-icon i").attr("class", "bx bx-sun");
    });
    $("#semidark").on("click", function () {
        $("html").attr("class", "semi-dark");
        localStorage.setItem('admin-theme', 'semi-dark');
    });
    $("#minimaltheme").on("click", function () {
        $("html").attr("class", "minimal-theme");
        localStorage.setItem('admin-theme', 'minimal-theme');
    });

    // Header color functions
    function setHeaderColor(colorClass) {
        $("html").removeClass(function (index, className) {
            return (className.match(/(^|\s)headercolor\S+/g) || []).join(' ');
        });
        $("html").addClass("color-header " + colorClass);
        localStorage.setItem('headerColor', "color-header " + colorClass);
    }

    [1, 2, 3, 4, 5, 6, 7, 8].forEach(i => {
        $("#headercolor" + i).on("click", () => setHeaderColor("headercolor" + i));
    });

    // Sidebar color functions
    const sidebarThemes = {
        sidebarcolor1: () => $('html').attr('class', 'color-sidebar sidebarcolor1'),
        sidebarcolor2: () => $('html').attr('class', 'color-sidebar sidebarcolor2'),
        sidebarcolor3: () => $('html').attr('class', 'color-sidebar sidebarcolor3'),
        sidebarcolor4: () => $('html').attr('class', 'color-sidebar sidebarcolor4'),
        sidebarcolor5: () => $('html').attr('class', 'color-sidebar sidebarcolor5'),
        sidebarcolor6: () => $('html').attr('class', 'color-sidebar sidebarcolor6'),
        sidebarcolor7: () => $('html').attr('class', 'color-sidebar sidebarcolor7'),
        sidebarcolor8: () => $('html').attr('class', 'color-sidebar sidebarcolor8'),
    };

    Object.keys(sidebarThemes).forEach(key => {
        $("#" + key).click(function () {
            sidebarThemes[key]();
            localStorage.setItem('sidebarColor', 'color-sidebar ' + key);
        });
    });

    // Clear theme settings button
    $("#clearThemeSettings").on("click", function () {
        localStorage.removeItem('admin-theme');
        localStorage.removeItem('headerColor');
        localStorage.removeItem('sidebarColor');
        location.reload();
    });
});
