export function handleBrokenImage(img) {
    const scope = img.getAttribute('data-scope');
    let fallbackSrc = '/assets/images/defaults/default.png'; // general fallback

    switch (scope) {
        case 'category':
            fallbackSrc = '/assets/images/defaults/category.png';
            break;
        case 'user':
            fallbackSrc = '/assets/images/defaults/user.png';
            break;
        case 'product':
            fallbackSrc = '/assets/images/defaults/product.png';
            break;
        default:
            fallbackSrc = '/assets/images/defaults/default.png';
            break;
    }

    img.onerror = null; // prevent infinite loop if fallback is also broken
    img.src = fallbackSrc;
}
