@props(['wire' => false , 'address' , 'selection' => false, 'selected' => false])
<li @if($wire) wire:key="address-{{ $address->id }}" @endif class="">
    <div class="relative block rounded-lg border p-4 shadow hover:border-border/50 <?php if ($selected) echo "!border-primary"  ?>">
        <div class="mb-4 flex justify-between gap-x-2 sm:mb-2">
            <div class="line-clamp-1 text-sm text-text/95 xs:text-base">
                <div class="flex gap-1">
                    <div class="flex min-w-fit">
                        <p>{{ $address->province }}</p>,
                        <p>{{ $address->city }}</p>,
                    </div>
                    <p>{{ $address->address }}</p>
                </div>
                <div class="flex gap-1">
                    <p> {{ __('plaque') }}: {{ $address->plaque }}</p>
                    <p> {{ __('unit') }}: {{ $address->unit }}</p>
                    <p> {{ __('zip-code') }}: {{ $address->zip_code }}</p>
                </div>
            </div>
        </div>
        <div class="flex flex-col justify-between gap-2 sm:flex-row sm:items-center">

            <p class="line-clamp-1 text-sm text-text/60">
                {{ $address->owner_is_receiver ? $address->receiver_name : auth()->user()->name }}
            </p>

            <div class="flex w-full gap-2 sm:w-fit">
                <div>
                    <button wire:click="deleteAddress({{ $address->id }})" wire:loading.attr="disabled"
                        wire:target="deleteAddress" type="button"
                        class="inline-flex h-8 w-full items-center justify-center gap-x-2 whitespace-nowrap rounded-md bg-warning/10 px-3 text-sm font-medium text-warning ring-offset-background transition-colors hover:bg-warning/20 focus-visible:outline-none focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50">
                        <div class="i-material-symbols-wrong-location-outline-rounded size-5"></div>
                        {{ __('Delete') }}
                        <div wire:loading wire:target="deleteAddress"
                            class="i-lucide-loader-circle animate-spin"></div>
                    </button>
                </div>
                <div>
                    <button type="button"
                        @click="if ($wire.$parent.modelId != {{ $address->id }}) { $dispatch('update-action', { action:'update', modelId: {{ $address->id }} }) }"
                        class="inline-flex h-8 w-full items-center justify-center gap-x-2 whitespace-nowrap rounded-md bg-success/10 px-3 text-sm font-medium text-success ring-offset-background transition-colors hover:bg-success/20 focus-visible:outline-none disabled:pointer-events-none disabled:opacity-50">
                        <div class="i-material-symbols-edit-location-alt-outline-rounded size-5"></div>
                        {{ __('Edit') }}
                    </button>
                </div>
                @if ($selection === true)
                <div>
                    <button type="button"
                        @click="$dispatch('address-selected', { addressId:{{ $address->id }} })"
                        class="inline-flex h-8 w-full items-center justify-center gap-x-2 whitespace-nowrap rounded-md bg-success/10 px-3 text-sm font-medium text-success ring-offset-background transition-colors hover:bg-success/20 focus-visible:outline-none disabled:pointer-events-none disabled:opacity-50">
                        <div class="i-material-symbols-edit-location-alt-outline-rounded size-5"></div>
                        {{ __('Select') }}
                    </button>
                </div>
                @endif
            </div>
        </div>
    </div>
</li>
