@props(['posts'])
<section class="container py-10">
    <div class="mb-6 flex items-center justify-between gap-x-6 text-nowrap">
        <h4 class="font-semiBold lg:text-xl">{{ __('Blog') }}</h4>
        <div class="h-[0.25px] w-full bg-secondary"></div>
        <a href="{{route('blog')}}">
            <div class="flex cursor-pointer items-center gap-x-2 text-sm text-primary duration-200 hover:text-primary/80 lg:text-base">
                <p>{{ __('see all') }}</p>
                <i class="i-carbon-chevron-left"></i>
            </div>
        </a>
    </div>

    <div>
        <div class="swiper blog-swiper !px-px pt-4">
            <div class="swiper-wrapper py-px">
                @foreach ($posts as $post )
                <div class="swiper-slide">
                    <x-blesser.element.single-post-card :post="$post" />
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
