@props(['preInvoice' => null])

@if ($preInvoice !== null)
<div class="p-6">
    {{-- Header --}}
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-100">
            {{ __('Pre-Invoice Details') }} #{{ $preInvoice->id }}
        </h2>

    </div>

    {{-- Customer Info --}}
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-8 bg-white border rounded-lg p-5 shadow-sm
                dark:bg-secondary/0.5 dark:border-gray-700">
        <div>
            <h3 class="text-lg font-semibold mb-2 text-gray-700 dark:text-gray-100">
                {{ __('Customer Information') }}
            </h3>
            <ul class="text-sm text-gray-700 dark:text-gray-300 space-y-1">
                <li><strong>{{ __('Customer Name') }}:</strong> {{ $preInvoice->customer_name ?? '-' }}</li>
                <li><strong>{{ __('Company Name') }}:</strong> {{ $preInvoice->company_name ?? '-' }}</li>
                <li><strong>{{ __('Phone') }}:</strong> {{ $preInvoice->phone ?? '-' }}</li>
                <li><strong>{{ __('Email') }}:</strong> {{ $preInvoice->email ?? '-' }}</li>
                <li><strong>{{ __('Address') }}:</strong> {{ $preInvoice->address ?? '-' }}</li>
                <li><strong>{{ __('City') }}:</strong> {{ $preInvoice->city ?? '-' }}</li>
                <li><strong>{{ __('Postal Code') }}:</strong> {{ $preInvoice->postal_code ?? '-' }}</li>
            </ul>
        </div>

        <div>
            <h3 class="text-lg font-semibold mb-2 text-gray-700 dark:text-gray-100">
                {{ __('Status and Overview') }}
            </h3>
            <ul class="text-sm text-gray-700 dark:text-gray-300 space-y-1">
                <li>
                    <strong>{{ __('Status') }}:</strong>
                    @php
                    $statusColors = [
                    'open' => 'bg-blue-100 text-blue-700 dark:bg-blue-900 dark:text-blue-300',
                    'closed' => 'bg-gray-100 text-gray-700 dark:bg-secondary/0.5 dark:text-gray-300',
                    'awarded' => 'bg-green-100 text-green-700 dark:bg-green-900 dark:text-green-300',
                    'cancelled' => 'bg-red-100 text-red-700 dark:bg-red-900 dark:text-red-300',
                    ];
                    @endphp
                    <span class="px-2 py-1 rounded-full text-xs {{ $statusColors[$preInvoice->status] ?? '' }}">
                        {{ __($preInvoice->status) }}
                    </span>
                </li>
                <li>
                    <strong>{{ __('Paid') }}:</strong>
                    @if($preInvoice->is_paid)
                    <span class="text-green-600 dark:text-green-400 font-semibold">
                        {{ __('Yes') }} ({{ number_format($preInvoice->paid_amount) }} {{ __('Toman') }})
                    </span>
                    @else
                    <span class="text-red-600 dark:text-red-400 font-semibold">{{ __('No') }}</span>
                    @endif
                </li>
                <li><strong>{{ __('Created At') }}:</strong> {{ verta($preInvoice->created_at)->format('Y/m/d H:i') }}</li>
                <li><strong>{{ __('Notes') }}:</strong> {{ $preInvoice->notes ?? '-' }}</li>
            </ul>
        </div>
    </div>

    {{-- Items --}}
    <div class="mb-8 bg-white border rounded-lg shadow-sm overflow-x-auto dark:bg-secondary/0.5 dark:border-gray-700">
        <div class="p-4 border-b dark:border-gray-700">
            <h3 class="text-lg font-semibold text-gray-700 dark:text-gray-100">{{ __('Items List') }}</h3>
        </div>

        <table class="min-w-full text-sm text-gray-700 dark:text-gray-300">
            <thead class="bg-gray-50 border-b text-gray-600 dark:bg-secondary/0.5 dark:border-gray-600 dark:text-gray-200">
                <tr>
                    <th class="px-4 py-3 text-right">#</th>
                    <th class="px-4 py-3 text-right">{{ __('Item Name') }}</th>
                    <th class="px-4 py-3 text-right">{{ __('Quantity') }}</th>
                    <th class="px-4 py-3 text-right">{{ __('Unit') }}</th>
                    <th class="px-4 py-3 text-right">{{ __('Description') }}</th>
                    <th class="px-4 py-3 text-right">{{ __('External Link') }}</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                @foreach($preInvoice->items as $index => $item)
                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50">
                    <td class="px-4 py-3">{{ $index + 1 }}</td>
                    <td class="px-4 py-3 font-medium">{{ $item->name }}</td>
                    <td class="px-4 py-3">{{ $item->qty }}</td>
                    <td class="px-4 py-3">{{ $item->unit ?? '-' }}</td>
                    <td class="px-4 py-3 text-gray-600 dark:text-gray-400">{{ $item->description ?? '-' }}</td>
                    <td class="px-4 py-3">
                        @if($item->external_url)
                        <a href="{{ $item->external_url }}" target="_blank"
                            class="text-blue-600 hover:text-blue-800 underline dark:text-blue-400 dark:hover:text-blue-300">
                            {{ __('View Link') }}
                        </a>
                        @else
                        -
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    {{-- Quotes Section --}}
    @if($preInvoice->quotes->count())
    <div class="bg-white mb-8 border rounded-lg shadow-sm dark:bg-secondary/0.5 dark:border-gray-700">
        <div class="p-4 border-b dark:border-gray-700">
            <h3 class="text-lg font-semibold text-gray-700 dark:text-gray-100">{{ __('Supplier Quotes') }}</h3>
        </div>

        <table class="min-w-full text-sm text-gray-700 dark:text-gray-300">
            <thead class="bg-gray-50 border-b text-gray-600 dark:bg-secondary/0.5 dark:border-gray-600 dark:text-gray-200">
                <tr>
                    <th class="px-4 py-3 text-right">#</th>
                    <th class="px-4 py-3 text-right">{{ __('Supplier') }}</th>
                    <th class="px-4 py-3 text-right">{{ __('Total') }}</th>
                    <th class="px-4 py-3 text-right">{{ __('Terms') }}</th>
                    <th class="px-4 py-3 text-right">{{ __('Status') }}</th>
                    <th class="px-4 py-3 text-right">{{ __('Date') }}</th>
                    <th class="px-4 py-3 text-right">{{ __('Actions') }}</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                @foreach($preInvoice->quotes as $index => $quote)
                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50">
                    <td class="px-4 py-3">{{ $index + 1 }}</td>
                    <td class="px-4 py-3 font-medium">
                        {{ $quote->supplier->name ?? '—' }}

                    </td>
                    <td class="px-4 py-3">{{ number_format($quote->total) }} </td>
                    <td class="px-4 py-3">{{ Str::limit($quote->terms, 50) ?? '-' }}</td>
                    <td class="px-4 py-3">
                        <span class="px-2 py-1 text-xs rounded-full">
                            {{ __($quote->status) ?? $quote->status }}
                        </span>
                    </td>
                    <td class="px-4 py-3 text-gray-500 dark:text-gray-400">{{ verta($quote->created_at)->format('Y/m/d') }}</td>
                    <td>
                        @if ($preInvoice->selected_quote_id !== $quote->id)
                        <form action="{{ route('pre-invoice.quote.selection') }}" method="POST">
                            @csrf
                            <input type="text" name="pre_invoice" value="{{ $preInvoice->id }}" hidden>
                            <input type="text" name="quote" value="{{ $quote->id }}" hidden>
                            <button class="px-2 py-1 text-xs rounded-full bg-green-600 text-white cursor-pointer hover:bg-green-900 transition">
                                {{ __('select quote')  }}
                            </button>
                        </form>
                        @else
                        <span class="px-2 py-1 text-xs rounded-full bg-indigo-600 text-white cursor-pointer hover:bg-indigo-900 transition">
                            {{ __('Selected') }}
                        </span>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @else
    <div class="p-6  mb-8 text-center text-gray-500 border rounded-lg bg-gray-50
                    dark:bg-secondary/0.5 dark:text-gray-400 dark:border-gray-700">
        {{ __('No quotes have been submitted yet.') }}
    </div>
    @endif

    {{-- comparison table --}}
    @if($preInvoice->quotes->count())
    @php
    $compression = $preInvoice->createCompressionQuote()
    @endphp
    <div class="bg-white border rounded-lg shadow-sm dark:bg-secondary/0.5 dark:border-gray-700">
        <div class="p-4 border-b dark:border-gray-700">
            <h3 class="text-lg font-semibold text-gray-700 dark:text-gray-100">{{ __('Supplier Quotes Compression') }}</h3>
        </div>

        <table class="min-w-full text-sm text-gray-700 dark:text-gray-300 text-center">
            <thead class="bg-gray-50 border-b text-gray-600 dark:bg-secondary/0.5 dark:border-gray-600 dark:text-gray-200">
                <tr>

                    @foreach ($compression['headers'] as $h)
                    <th class="px-4 py-3 text-center">{{ $h['name'] }}</th>
                    @endforeach
                    <th class="px-4 py-3 text-center">{{ __('Products / Items') }}</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                @foreach ($compression['rows'] as $row)
                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50">
                    @foreach ($row['sellers'] as $cell)
                    <td class="px-4 py-3">
                        @if(!is_null($cell['price']))
                        {{ number_format($cell['price']) }}
                        @else
                        -
                        @endif
                    </td>
                    @endforeach
                    <td>{{ $row['item_name'] }}</td>
                </tr>
                @endforeach

            </tbody>
        </table>
    </div>
    @else
    <div class="p-6 text-center text-gray-500 border rounded-lg bg-gray-50
                    dark:bg-secondary/0.5 dark:text-gray-400 dark:border-gray-700">
        {{ __('No quotes have been submitted yet.') }}
    </div>
    @endif
</div>
@endif
