@if ($products->isNotEmpty())
<section class="container py-10">
    <div class="flex gap-x-4 rounded-lg bg-gradient-to-l from-rose-500 to-red-500 px-1 py-3 shadow">
        <div class="swiper product-slider-wrapped rounded-base grow p-px">
            <div class="swiper-wrapper [&>div:last-child_a]:rounded-l-lg [&>div:nth-child(2)_a]:rounded-r-lg">
                @if (false)
                <div class="swiper-slide">
                    <div class="flex h-full items-center justify-center">
                        <div class="flex flex-col items-center justify-center space-y-4 text-white">
                            <div class="i-solar-fire-outline size-12 stroke-2"></div>
                            <div class="flex select-none flex-col items-center justify-center space-y-2 text-lg font-semibold md:text-xl xl:text-2xl">
                                <p>پیشنهادات</p>
                                <p>شگفت</p>
                                <p>انگیز</p>
                                <div data-expire-date="2025-05-01T00:00:00" class="countdown-wrapper flex gap-1 text-sm text-text">
                                    <div data-id="seconds" class="flex size-8 items-center justify-center rounded-lg bg-muted"></div>
                                    <div data-id="minutes" class="flex size-8 items-center justify-center rounded-lg bg-muted"></div>
                                    <div data-id="hours" class="flex size-8 items-center justify-center rounded-lg bg-muted"></div>
                                    <div data-id="days" class="flex size-8 items-center justify-center rounded-lg bg-muted"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endif


                @foreach ($products as $product)
                <div class="swiper-slide">
                    <a href="{{ route('product.details' ,$product->slug) }}" class="relative block overflow-hidden bg-muted">
                        <div class="mb-4 bg-secondary p-2 lg:p-4">
                            <!-- Special Sale Percentage  -->
                            <div class="absolute right-2 top-0 rounded-b-full bg-warning px-1 py-1.5 text-center text-sm font-medium text-white md:text-base">
                                %{{ $product->off_rate }}
                            </div>
                            <!-- Image -->
                            <img src="{{ $product->brand_img }}" alt="Blesser" class="aspect-[1/1] rounded-xl object-cover" />
                        </div>
                        <div class="mb-1 px-2 lg:px-4">
                            <p class="line-clamp-2 h-10 text-sm xs:h-12 xs:text-base">
                                {{ $product->title }}
                            </p>
                            <div class="gap-x-1 text-end font-bold text-primary">
                                @if ($product->discount_price != 0 && $product->discount_price !== null)
                                <div class="h-5 text-end text-sm text-text/50 xs:text-base">
                                    <del>{{ number_format($product->price) }} {{ getCurrency() }}</del>
                                </div>
                                <span class="text-sm xs:text-base">{{ number_format($product->discount_price) }}</span>
                                <span class="text-sm font-light">{{ getCurrency() }}</span>
                                @else
                                <div class="h-5 text-end text-sm text-text/50 xs:text-base">&nbsp;</div>

                                @if ($product->price != 0)
                                <span class="text-sm xs:text-base">{{ number_format($product->price) }}</span>
                                @else
                                <span class="text-sm xs:text-base">{{ $product->display_price }}</span>
                                @endif
                                <span class="text-sm font-light">{{ getCurrency() }}</span>
                                @endif
                            </div>
                        </div>

                        @if (false)
                        <div class="h-8 px-2 lg:px-4">
                            <!-- Countdown -->
                            <div class="product-special-timer text-end text-sm text-warning" dir="ltr" data-expire-date="2025-06-01T00:00:00"></div>
                            <!-- Proccess Bar -->
                            <div class="h-1 w-full rounded-full bg-secondary" dir="ltr">
                                <div class="progress-bar h-1 rounded-full bg-warning transition-all duration-1000" data-start-date="2024-05-01T00:00:00" data-expire-date="2025-04-01T00:00:00"></div>
                            </div>
                        </div>
                        @endif
                    </a>
                </div>
                @endforeach


                <!-- Show more -->
                <div class="swiper-slide">
                    <a href="{{ route('shop') }}" class="flex h-full items-center justify-center bg-muted">
                        <div class="flex flex-col items-center justify-center gap-y-4 text-primary">
                            <div class="rounded-full border-2 border-primary p-2">
                                <div class="i-lucide-chevron-left size-8"></div>
                            </div>
                            <div class="text-lg font-medium">{{ __('see all') }}</div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="swiper-button-next main-slider-nav-button"></div>
            <div class="swiper-button-prev main-slider-nav-button"></div>
        </div>
    </div>
</section>
@endif
