@props(['product'])
<div class="{{ $attributes->get('class') }} border-gradient relative rounded-[--product-card-radius] p-px [--product-card-radius:theme(borderRadius.2xl)] before:absolute before:-inset-px before:h-[calc(100%+2px)] before:w-[calc(100%+2px)] before:rounded-[var(--product-card-radius)] before:content-['']">
    <a href="{{ route('product.details' , $product->slug) }}" class="relative block overflow-hidden rounded-[calc(var(--product-card-radius)-1px)] bg-muted">
        <div class="mb-4 bg-secondary p-2 lg:p-4">
            <!-- Special Sale Percentage  -->
            @if (!is_null($product->off_rate) && $product->off_rate != 0)
            <div class="absolute right-2 top-0 rounded-b-full bg-warning px-1 py-1.5 text-center text-sm font-medium text-white md:text-base">
                %{{ $product->off_rate }}
            </div>
            @endif
            <!-- Image -->
            <img src="{{ $product->brand_img }}" alt=" Blesser" class="aspect-[1/1] w-full rounded-xl object-cover" />
        </div>
        <div class="mb-1 px-2 lg:px-4">
            <p class="line-clamp-2 h-10 text-sm xs:h-12 xs:text-base">
                {{ $product->title }}
            </p>
            @if ($product->isInStock())
            <div class="gap-x-1 text-end font-bold text-primary mb-1 px-2 lg:px-4 ">
                @if ($product->discount_price != 0 && $product->discount_price != null)
                <div class="h-5 text-end text-sm text-text/50 xs:text-base">
                    <del>
                        {{ number_format($product->price) }} {{ getCurrency() }}
                    </del>
                </div>
                <span class="text-sm xs:text-base">{{ number_format($product->discount_price) }}</span>
                <span class="text-sm font-light">{{ getCurrency() }}</span>
                @else
                <div class="h-5 text-end text-sm text-text/50 xs:text-base">
                </div>
                <span class="text-sm xs:text-base">{{ $product->display_price }}</span>
                <span class="text-sm font-light">{{ $product->price != 0 ? getCurrency() : '' }}</span>
                @endif
            </div>
            @else
            <div class="gap-x-1 text-end font-bold text-red-500 mb-1 px-2 lg:px-4 ">
                <div class="h-5 text-end text-sm text-text/50 xs:text-base">
                </div>
                <span class="">{{ __('Out of stock') }}</span>
            </div>
            @endif

        </div>
        @if (false)
        <div class="h-8 px-2 lg:px-4">
            <!-- Countdown -->

            <div class="product-special-timer text-end text-sm text-warning" dir="ltr" data-expire-date="2024-12-01T00:00:00"></div>

            <!-- Proccess Bar -->
            <div class="h-1 w-full rounded-full bg-secondary" dir="ltr">
                <div class="progress-bar h-1 rounded-full bg-warning transition-all duration-1000" data-start-date="2024-05-01T00:00:00" data-expire-date="2024-12-01T00:00:00"></div>
            </div>
        </div>
        @endif
    </a>
</div>
