@props([
'id' => 'quill-' . uniqid(),
'name' => 'content',
'label' => null,
'value' => '',
'placeholder' => 'Type your content...',
'height' => '200px',
'direction' => 'rtl', // default is RTL
'font' => 'IRANYekanXFaNum, sans-serif',
])

<div class="form-group">
    @if($label)
    <label for="{{ $id }}" class="form-label">{{ $label }}</label>
    @endif

    <div id="{{ $id }}-editor"
        class="quill-editor"
        style="height:<?php echo $height ?>;"
        data-placeholder="{{ $placeholder }}"
        data-direction="{{ $direction }}"
        data-font="{{ $font }}">
    </div>

    <input type="hidden" name="{{ $name }}" id="{{ $id }}" value="{{ $value }}">
</div>
