@props(['fields' => [], 'values' => [], 'wireModel'])

<div x-data="{ settings: @entangle($wireModel).defer }" class="space-y-4">
    @foreach ($fields as $field)
        @php
            $name = $field['name'];
            $type = $field['type'];
            $label = $field['label'] ?? ucfirst($name);
        @endphp

        <div>
            <label class="block text-sm font-medium mb-1">{{ $label }}</label>

            {{-- Text Field --}}
            @if ($type === 'text')
                <input type="text" x-model="settings['{{ $name }}']" class="form-input w-full" />
            @endif

            {{-- Image Field --}}
            @if ($type === 'image')
                <input type="text" x-model="settings['{{ $name }}']" placeholder="Image URL..." class="form-input w-full" />
            @endif

            {{-- Textarea Field --}}
            @if ($type === 'textarea')
                <textarea x-model="settings['{{ $name }}']" class="form-textarea w-full"></textarea>
            @endif

            {{-- Repeater Field --}}
            @if ($type === 'repeater')
                <div x-data="{
                            items: Array.isArray(settings['{{ $name }}']) ? settings['{{ $name }}'] : [{}],
                            add() { this.items.push({}); this.sync() },
                            remove(index) { this.items.splice(index, 1); this.sync() },
                            sync() { settings['{{ $name }}'] = this.items }
                        }" class="space-y-2">
                    <template x-for="(item, idx) in items" :key="idx">
                        <div class="p-3 border rounded-md space-y-1 bg-gray-50">
                            @foreach ($field['fields'] as $sub)
                                <div>
                                    <label class="text-xs">{{ $sub['label'] ?? $sub['name'] }}</label>
                                    <input type="text" x-model="item['{{ $sub['name'] }}']" class="form-input w-full text-sm" />
                                </div>
                            @endforeach
                            <button type="button" class="text-xs text-red-500" @click="remove(idx)">Remove</button>
                        </div>
                    </template>
                    <button type="button" class="text-sm text-blue-500 mt-2" @click="add()">+ Add</button>
                </div>
            @endif
        </div>
    @endforeach
</div>
