<div class="card">
    <div class="row card-body">
        <div class="col-sm-2">
            <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                @foreach ($options as $groupKey => $group )
                <button class="nav-link {{ $loop->first ? 'active' : '' }}"
                    id="v-pills-{{ $groupKey }}-tab"
                    data-bs-toggle="pill"
                    data-bs-target="#v-pills-{{ $groupKey }}"
                    type="button"
                    role="tab"
                    aria-controls="v-pills-{{ $groupKey }}"
                    aria-selected="{{ $loop->first ? 'true' : 'false' }}">
                    {{ __($groupKey) }}
                </button>
                @endforeach
            </div>
        </div>

        <div class="col-sm-10">
            <form action="{{ route('admin.option.panel-v2.store') }}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="tab-content" id="v-pills-tabContent">
                    @foreach ($options as $groupKey => $group )
                    <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }}"
                        id="v-pills-{{ $groupKey }}"
                        role="tabpanel"
                        aria-labelledby="v-pills-{{ $groupKey }}-tab"
                        tabindex="0">

                        @foreach ($group as $input)
                        <div class="mb-3">
                            <label for="{{ $input['name'] }}" class="form-label">{{ __($input['label']) }}</label>

                            @switch($input['type'])
                            @case('textarea')
                            <textarea class="form-control"
                                name="settings[{{ $input['name'] }}]"
                                id="{{ $input['name'] }}"
                                rows="3">{{ old("settings.{$input['name']}", $currentOptions[$input['name']]->value ?? $input['default']) }}</textarea>
                            @break

                            @case('select')
                            <select class="form-select"
                                name="settings[{{ $input['name'] }}]"
                                id="{{ $input['name'] }}">
                                @foreach ($input['items'] as $option)

                                <option value="{{ $option }}"
                                    @selected(old("settings.{$input['name']}",$currentOptions[$input['name']]->value ?? $input['default'])==$option)>
                                    {{ $option }}
                                </option>
                                @endforeach
                            </select>
                            @break

                            @case('image')
                            <input type="file"
                                class="form-control"
                                name="settings[{{ $input['name'] }}]"
                                id="{{ $input['name'] }}">
                            @break

                            @case('boolean')
                            <select class="form-select"
                                name="settings[{{ $input['name'] }}]"
                                id="{{ $input['name'] }}">
                                <option value="1" @selected(old("settings.{$input['name']}", $currentOptions[$input['name']]->value ?? $input['default'])==1)>فعال</option>
                                <option value="0" @selected(old("settings.{$input['name']}", $currentOptions[$input['name']]->value ?? $input['default'])==0)>غیرفعال</option>
                            </select>
                            @break

                            @default
                            <input type="{{ $input['type'] ?? 'text' }}"
                                class="form-control"
                                name="settings[{{ $input['name'] }}]"
                                id="{{ $input['name'] }}"
                                value="{{ old("settings.{$input['name']}", $currentOptions[$input['name']]->value ?? $input['default']) }}">
                            @endswitch
                        </div>
                        @endforeach

                    </div>
                    @endforeach
                </div>

                <div class="text-end mt-4">
                    <button class="btn btn-primary" type="submit">ذخیره تنظیمات</button>
                </div>
            </form>
        </div>
    </div>
</div>
