@props([
'amount' => '$4805',
'title' => 'Revenue',
'change' => '',
'trend' => 'success', // can be 'success' or 'danger' for up/down
])

<div class="card radius-10">
    <div class="card-body">
        <div class="d-flex align-items-center">
            <div>
                <p class="mb-0 text-secondary">{{ $title }}</p>
                <h4 class="my-1">{{ $amount }}</h4>
                @if ($change)
                <p class="mb-0 font-13 text-{{ $trend }}">
                    <i class="bx bxs-up-arrow align-middle"></i>{{ $change }}
                </p>
                @endif

            </div>
            <div class="widgets-icons bg-light-{{ $trend }} text-{{ $trend }} ms-auto">
                <i class="bx bxs-wallet"></i>
            </div>
        </div>
    </div>
</div>
