@props(['category' => null])

@php
$isEdit = isset($category) && $category->exists;
@endphp

<form class="" action="{{ $isEdit ? route('admin.categories.update', $category) : route('admin.categories.store') }}" method="POST" enctype="multipart/form-data">
    @csrf
    @if($isEdit)
    @method('PUT')
    @endif

    <div class="mb-3">
        <label class="form-label">{{ __('Name') }}</label>
        <input type="text" name="name" value="{{ old('name', $category->name ?? '') }}" class="form-control @error('name') is-invalid @enderror">
        @error('name')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Parent Category') }}</label>
        <select name="parent_id" class="form-select @error('parent_id') is-invalid @enderror">
            <option value="0">{{ __('None') }}</option>
            @foreach(\App\Models\Category::all() as $parent)
            <option value="{{ $parent->id }}" {{ old('parent_id', $category->parent_id ?? $_GET['category'] ?? '') == $parent->id ? 'selected' : '' }}>
                {{ $parent->name }}
            </option>
            @endforeach
        </select>
        @error('parent_id')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Commission') }} (%)</label>
        <input type="number" step="0.01" name="commission" value="{{ old('commission', $category->commission ?? '') }}" class="form-control @error('commission') is-invalid @enderror">
        @error('commission')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Order Index') }}</label>
        <input type="number" name="order_index" value="{{ old('order_index', $category->order_index ?? '') }}" class="form-control @error('order_index') is-invalid @enderror">
        @error('order_index')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Image') }}</label>
        <input type="file" name="image" class="form-control @error('image') is-invalid @enderror">
        @error('image')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
        @if($isEdit && $category->image)
        <img src="{{ asset('uploads/' . $category->image) }}" class="img-thumbnail mt-2" style="max-height: 150px;">
        @endif
    </div>

    <button type="submit" class="btn btn-primary">{{ $isEdit ? 'Update' : 'Create' }} {{ __('Category') }}</button>
</form>
